appModule.service('native', function () {
    var UC = window.top.uc;
    var inputting = false;

    function getErrorObject() {
        try {
            throw Error('');
        } catch (err) {
            return err;
        }
    };
    var nativeService = {
        getUCCDomain: function (callback) {//获取ucc domain server 地址
            ucClient.ClientService.getBbsServerDomain(function (data) {
                if (data[0] == 0) {
                    callback(data[1].replace(':443', '').replace('https://', 'http://'));
                } else {
                    callback(null);
                }
            });
        },
        getUserInfo: function () {//获取当前用户信息
            var currentUser = ucClient.ContactService.getCurrentUserInfoSync();
            localStorage["notice_user"] = JSON.stringify(currentUser);
            return currentUser;
        },
        getSessionInfo: function (callback) {//获取session 信息
            ucClient.ClientService.getSessionId(function (data) {
                localStorage["notice_sessionId"] = data[1];
                callback(data[1]);
            });
        },
        ucFileUpload: function (path, callback) {//调用一期接口上传文件
            ucClient.FileTransferService.uploadFile(path, 8,callback);
        },
        ucOpenFileDialog: function (title, types, callback, multiple) {//调用一期接口打开文件对话框
            var selectMore = multiple ? true : false;
            ucClient.Dialog.runOpenDialog(title, types, selectMore, callback);
        },
        ucGetDropImages: function (callback, sizeLimit) {
            ucClient.Window.getDroppedFiles(
                function (args) {
                    if (args[0] != 0) {
                        return;
                    }
                    var paths = [];
                    args[1].forEach(function (file) {
                        if (file.path.endsWith('.jpg') || file.path.endsWith('.jpeg') || file.path.endsWith('.png') || file.path.endsWith('.gif')) {
                            paths.push(file.path);
                        }
                    });
                    if (paths.length > 0) {
                        for (var i = 0; i < paths.length; i++) {
                            if (ucClient.File.getFileSize(paths[i]) > sizeLimit) {
                                callback({
                                    errorCode: -1,
                                    msg: "文件尺寸超出范围"
                                });
                                return;
                            }
                        }
                    }
                    callback({
                        errorCode: 0,
                        paths: paths
                    });
                }
            );
        },
        saveLocalStore: function (key, value) {//将数据持久化到native db
            ucClient.ClientService.updateValueByKey("notice", key, value);
            localStorage[key] = value;
        },
        getLocalStore: function (key) {
            //    return ucClient.ClientService.getValueByKeySync("notice",key);
            return localStorage[key];
        },
        retrieveLocalData: function (key) {//临时方法 解决蜜蜂每次启动清空localstorage的问题
            return ucClient.ClientService.getValueByKeySync("notice", key);
        },
        getCropperPath: function () {//获取切图临时存储的路径
            return ucClient.ClientService.getDocumentDataDirSync(3) + '/cropped/temp_notice';
        },
        bindGlobalEvent: function (eventName, callback) {//绑定全局事件
            if (!!top) {
                top.ucClient.addEventListener(eventName, callback);
            }
        },
        triggerGlobalEvent: function (eventName, param) {//触发全局事件
            if (!param) {
                param = {};
            }
            if (!!top) {
                top.ucClient.dispatchGlobalEvent(eventName, param);
            }
        },
        unbindGlobalEvent: function (eventName, callback) {//取消绑定全局事件
            if (!!top) {
                top.ucClient.removeEventListener(eventName, callback);
            }
        },
        unbindDefaultEvent: function (callFn, callbackFun) {
            this.unbindGlobalEvent("subWindowFn", callFn);
            this.unbindGlobalEvent("subWindowCallback", callbackFun);
        },
        closeWindow: function () {  //关闭当前窗口
            ucClient.Window.close();
        },
        maximizeWindow: function () {//最大化窗口
            ucClient.Window.maximize();
        },
        restoreWindow: function () {//恢复当前窗口大小
            ucClient.Window.restore();
        },
        minimizeWindow: function () {//最小化当前窗口
            ucClient.Window.minimize();
        },
        log: function (logLevel, content, caller) {//日志
            caller = caller || 4;
            var err = getErrorObject();
            var caller_line = err.stack.split("\n")[caller];
            var index = caller_line.indexOf("at ");
            var content = caller_line.slice(index + 2, caller_line.length) + ']]' + content;
            ucClient.Log.writeLog('NOTICELOG', 0, logLevel, content);
        },
        openWindow: function (url, eventName, options) {//打开新窗口
            this.log(0, 'start open window:' + url);
            ucClient.Window.open(url, eventName, options, options.closeOtherWindow ? 1 : 0);
        },
        setCaretPosition: function (left, top) {//设置光标位置(修复输入法位置错误)
            if (inputting) {
                return;
            }
            setTimeout(function () {
                inputting = false;
            }, 300);
            ucClient.Window.setCaretPosition(parseInt(left), parseInt(top), 16);
            inputting = true;
        },
        getOrgInfo: function (id, callback) {
            if (!this.getOrgInfoCallbacks) {
                this.getOrgInfoCallbacks = {};
            }
            this.getOrgInfoCallbacks[id] = callback;
            var that = this;
            that.log(0, "start get org info " + id, 5);
            this.bindGlobalEvent(ucClient.ContactService.ORG_ADDRESS_BOOK_RECEIVED_EVENT, function (e) {
                if (e.detail && e.detail.errorCode == 0) {
                    var deptId = e.detail.department.id;
                    if (that.getOrgInfoCallbacks[deptId]) {
                        that.getOrgInfoCallbacks[deptId](e.detail.department);
                        delete that.getOrgInfoCallbacks[deptId];
                        that.log(0, "end get org info " + deptId, 5);
                        that.unbindGlobalEvent(ucClient.ContactService.ORG_ADDRESS_BOOK_RECEIVED_EVENT, arguments.callee);
                    }
                }
            });
            ucClient.ContactService.getOrgAddressBook(id, 0, 0, 0,'bbs');
        },
        backToApp: function () {
            UC.ui.Notice.MainPanel.addClass("hide");
        },
        openCloudDialog: function (opts) {
            this.requestNativeFn('uc.modules.cloud.CloudManager', 'selectCloudFile', [opts], function () {
            });
        },
        noticeChatType: function () {
            return 16; //UC.constants.Chat.ChatType.notice;
        },
        setTop: function (isSetTop) {
            ucClient.Window.setTop(isSetTop);
        },
        raiseCloudFileDownloadEvent: function (data) {
            this.triggerGlobalEvent("noticeCloudInfoDownload", {"data": data});
        },
        openAvatarChangesWindow: function (eventName, callback) {
            var that = this;
            that.avatarCallback = callback;
            UC.IUIService.openImageCropperWindow(eventName, function (args) {
                if (args.okOrCancel) {
                    var croppedImagePath = args.croppedImagePath;
                    that.log(0, "crop account image:" + croppedImagePath, 5);
                    var taskId = "";
                    that.bindGlobalEvent(ucClient.FileTransferService.FILETRANSFER_FILE_UPLOADED_EVENT, function (e) {
                        if (e.detail.errorCode === 0) {
                            var data = e.detail;
                            if (data.taskId == taskId) {
                                that.unbindGlobalEvent(ucClient.FileTransferService.FILETRANSFER_FILE_UPLOADED_EVENT, arguments.callee);
                                that.avatarCallback(data.downloadURL);
                            }
                        }
                    });
                    that.ucFileUpload(croppedImagePath, function (data) {
                        if (data[0] === 0) {
                            taskId = data[1];
                        }
                    });
                } else {
                    that.avatarCallback(null);
                }
            });
        },
        sendRequest: function (request, callback) {
            ucClient.BBSService.BBSRequest(request, callback);
        },
        addBBSEventHandler: function (taskId, callback) {
            if (!this.bbsCallback) {
                this.bbsCallback = {};
            }
            this.bbsCallback[taskId] = callback;
        },
        hideNoticePanel: function () {
            this.requestNativeFn('uc.modules.notice.NoticeManager', 'hidePanel', [], null);
            this.requestNativeFn('uc.modules.notice.NoticeManager', 'updateReadyToAuditNumber', [], null);
        },
        deleteFile: function (fileName) {
            ucClient.File.deleteFile(fileName);
        },
        getConversationTitle: function () {
            return UC.modules.notice.Notice.appInfo.appTitle;
        },
        getNoticeUnreadCount: function () {
            return UC.modules.notice.NoticeManager.getNoticeUnreadCount();
        },
        setNoticeUnreadCount: function (count) {
            UC.modules.notice.NoticeManager.setNoticeUnreadCount();
        },
        goToConversation: function () {
            if (UC.modules.main.Main.moduleId == UC.constants.UI.ModuleId.Notice) {
                UC.IUIService.changeModule(UC.constants.UI.ModuleId.Message);
            }
        },
        openUCAlert: function (title, msg, confirmText, callback) {
            UC.modules.component.PromptMessageBox.open({
                    title: title,
                    message: msg,
                    buttonMode: "ok",
                    OkText: confirmText,
                    status: 'Light-Blue'
                },
                function (result) {
                    callback(result);
                    this.close();
                });
        },
        getFileSize: function (path) {
            return ucClient.File.getFileSize(path);
        },
        getBasicUserInfo: function (id, callback) {
            if (!this.users) {
                this.users = {};
            }
            if (this.users[id]) {
                this.log(0, "get user info cache " + id, 5);
                if (callback) {
                    callback(this.users[id]);
                }

                return this.users[id];
            }

            if (!this.getUserInfoCallbacks) {
                this.getUserInfoCallbacks = {};
            }
            if (callback) {
                if (this.getUserInfoCallbacks[id]) {
                    this.getUserInfoCallbacks[id].callbacks.push(callback);
                    return;
                } else {
                    this.getUserInfoCallbacks[id] = {
                        callbacks: [callback]
                    };
                }
            }

            var that = this;
            that.log(0, "start get user info " + id, 5);
            if (!this.hasBindContactInfoEvent) {
                this.hasBindContactInfoEvent = true;
                this.bindGlobalEvent(ucClient.ContactService.BASIC_CONTACT_INFO_RECEIVED_EVENT, function (e) {
                    that.log(0, "receive contact event " + JSON.stringify(e.detail.contacts), 5);
                    if (e.detail && e.detail.errorCode == 0) {
                        for (var i = 0; i < e.detail.contacts.length; i++) {
                            var userId = e.detail.contacts[i].userId;
                            if (that.getUserInfoCallbacks[userId]) {
                                if (e.detail.contacts[i]) {
                                    var info = e.detail.contacts[i];
                                    info.avatar = info.localAvatar ? info.localAvatar : info.remoteAvatarUrl;
                                    that.users[userId] = info;
                                    that.getUserInfoCallbacks[userId].callbacks.forEach(function (callback) {
                                        if (callback) {
                                            callback(info);
                                        }
                                    });
                                }
                                delete that.getUserInfoCallbacks[userId];
                                that.log(0, "end get user info " + userId, 5);
                            }
                        }
                    }
                });
            }

            var result = ucClient.ContactService.getBasicContactInfoSync(id);
            if (!result) {
                return null;
            } else {
                that.log(0, "end get user info " + id, 5);
                result.avatar = result.localAvatar ? result.localAvatar : result.remoteAvatarUrl;
                that.users[id] = result;
                if (that.getUserInfoCallbacks[id]) {
                    that.getUserInfoCallbacks[id].callbacks.forEach(function (callback) {
                        if (callback) {
                            callback(result);
                        }
                    });
                    delete that.getUserInfoCallbacks[id];
                }
                return result;
            }
        },
        fileExist: function (path) {
            return ucClient.File.fileExist(path);
        },
        bindWindowRestoreEvent: function (handler) {
            if (this.windowRestoreEventHandler) {
                this.unbindWindowRestoreEvent(this.windowRestoreEventHandler);
            }
            this.windowRestoreEventHandler = handler;
            this.bindGlobalEvent(ucClient.Window.Status.RESTORED_FROM_MAXIMIZED, handler);
        },
        unbindWindowRestoreEvent: function (handler) {
            this.unbindGlobalEvent(ucClient.Window.Status.RESTORED_FROM_MAXIMIZED, handler);
        },
        bindWindowMaxListener: function (handler) {
            if (this.windowMaxEventHandler) {
                this.unbindWindowMaxEvent(this.windowMaxEventHandler);
            }
            this.windowMaxEventHandler = handler;
            this.bindGlobalEvent(ucClient.Window.Status.MAXIMIZED_FROM_NORMAL, handler);
        },
        unbindWindowMaxEvent: function (handler) {
            this.unbindGlobalEvent(ucClient.Window.Status.MAXIMIZED_FROM_NORMAL, handler);
        },
        bindWindowCloseListener: function (handler) {
            if (this.windowCloseEventHandler) {
                this.unbindWindowMaxEvent(this.windowCloseEventHandler);
            }
            this.windowCloseEventHandler = handler;
            this.bindGlobalEvent('WindowCloseFromSystemPanelEvent', handler);
        },
        unbindWindowCloseEvent: function () {
            this.unbindGlobalEvent('WindowCloseFromSystemPanelEvent', this.windowCloseEventHandler);
        },
        onDeleteLastAccount: function () {
            UC.modules.notice.NoticeManager.onDeleteLastAccount();
        },
        convertMessageToHTML: function (message) {
            return UC.modules.notice.NoticeManager.covertMsgToDomStr(message);
        },
        showFileTransferModule: function () {
            UC.IUIService.changeModule(UC.constants.UI.ModuleId.UploadDownloadList);
        },
        parseCommentCopyData: function (data) {
            return UC.modules.notice.NoticeManager.parseCommentCopyData(data);
        },
        convertDomStrToMsg: function (html) {
            return UC.modules.notice.NoticeManager.convertDomStrToMsg(html);
        },
        isWindowsOS: function () {
            return (navigator.platform == "Win32") || (navigator.platform == "Windows");
        },
        pageIsHidden: function () {
            return UC.modules.notice.NoticeManager.IsMainPanelHidden();
        },
        getLastNoticeId: function () {
            return UC.modules.notice.NoticeManager.getLastNoticeInfo();
        },
        callTotalUnread: function () {
            UC.modules.notice.NoticeManager.getUnreadMessage();
        },
        getClipboardData: function () {
            return ucClient.System.getClipboardData();
        },
        uploadFiles: function (urls, deferred, uploadingEventCallback, uploadedCallback) {
            var tasks = [], count = 0;
            var that = this;
            that.bindGlobalEvent(ucClient.FileTransferService.FILETRANSFER_FILE_UPLOADED_EVENT, function (e) {
                var index = tasks.findIndex(function (task) {
                    return task.taskId === e.detail.taskId;
                });
                if (index > -1) {
                    if (e.detail.errorCode === 0) {
                        tasks[index].newURL = e.detail.downloadURL;
                        tasks[index].fileName = e.detail.fileName;
                        tasks[index].fileSize = e.detail.fileSize;
                    } else {
                        tasks[index].newURL = null;
                    }
                    count++;
                    if (uploadedCallback) {
                        uploadedCallback(tasks[index]);
                    }
                    if (count === urls.length) {
                        that.unbindGlobalEvent(ucClient.FileTransferService.FILETRANSFER_FILE_UPLOADED_EVENT, arguments.callee);
                        if (uploadingEventCallback) {
                            that.unbindGlobalEvent(ucClient.FileTransferService.FILETRANSFER_FILE_UPLOADING_EVENT, uploadingEventHandler);
                        }
                        deferred.resolve(tasks);
                    }
                }
            });

            function uploadingEventHandler(e) {
                var index = tasks.findIndex(function (task) {
                    return task.taskId === e.detail.taskId;
                });
                if (index > -1) {
                    if (e.detail.errorCode === 0) {
                        uploadingEventCallback(tasks[index], e.detail.percent);
                    }
                }
            }

            if (uploadingEventCallback) {
                that.bindGlobalEvent(ucClient.FileTransferService.FILETRANSFER_FILE_UPLOADING_EVENT, uploadingEventHandler);
            }

            var callFileUpload = function (url) {
                that.ucFileUpload(url, function (result) {
                    if (result[0] === 0) {
                        tasks.push({
                            taskId: result[1],
                            originalURL: url
                        });
                    } else {
                        tasks.push({
                            taskId: -1,
                            originalURL: url,
                            newURL: null
                        });
                        count++;
                        if (count === urls.length) {
                            deferred.resolve(tasks);
                        }
                    }
                });
            };
            urls.forEach(function (url) {
                callFileUpload(url);
            });
        },
        requestNativeFn: function (classFullName, fnName, params, callback) {
            if (!this.nativeFnNumber || this.nativeFnNumber == Number.MAX_SAFE_INTEGER) {
                this.nativeFnNumber = 0;
            }

            var taskId = Date.now().toString() + (this.nativeFnNumber++).toString();
            var that = this;
            this.bindGlobalEvent('onResponseFn', function (e) {
                var data = e.detail.data;
                if (data && data.taskId == taskId) {
                    that.unbindGlobalEvent('onResponseFn', arguments.callee);
                    if (callback) {
                        callback(data.result);
                    }
                }
            });
            this.triggerGlobalEvent('onRequestFn', {
                namespace: classFullName.split('.'),
                method: fnName,
                params: params,
                taskId: taskId
            });
        },
        getFileIcon: function (fileName, callback) {
            this.requestNativeFn('uc.util.StringUtil', 'getFileIcon', [fileName, true], function (result) {
                callback(result);
            });
        },
        downloadFile: function (url, savePath, callback) {
            if (!this.downloadQueue) {
                this.downloadQueue = {};
            }
            var that = this;
            var localPath = that.retrieveLocalData(url);
            if (localPath && that.fileExist(localPath)) {
                return callback(localPath);
            }
            that.bindGlobalEvent(ucClient.FileTransferService.FILETRANSFER_FILE_DOWNLOADED_EVENT, function (event) {
                var errorCode = event.detail.errorCode;
                var taskId = event.detail.taskId;
                var savePath = event.detail.savePath;

                if (!!that.downloadQueue[taskId]) {
                    if (errorCode == 0) {
                        ucClient.ClientService.updateValueByKey("notice", url, savePath);
                        that.downloadQueue[taskId].fn(savePath);
                        delete that.downloadQueue[taskId];
                    }
                    that.unbindGlobalEvent(ucClient.FileTransferService.FILETRANSFER_FILE_DOWNLOADED_EVENT, arguments.callee);
                }
            });

            ucClient.FileTransferService.downloadFile(url, savePath, function (args) {
                if (args[0] != 0 || args[1] == null) {
                    return;
                }
                var taskId = args[1];
                that.downloadQueue[taskId] = {
                    url: url,
                    fn: callback
                };
            });
        },
        playMedia: function (url, playingCallback, callback) {
            var that = this;
            that.stopPlayMedia();
            function startPlay(path, url) {
                callback(path, url);
                that.currentPlayingURL = path;
                that.playingCallback = playingCallback;
                localStorage.setItem('currentTaskAudio', path);
                ucClient.System.playSound(path, path, false, function () {
                });
            }

            if (!this.hasPlayingAudioListener) {
                this.hasPlayingAudioListener = true;
                that.bindGlobalEvent(ucClient.System.PLAYINGSOUND_NOTIFICATION, function (event) {
                    var id = event.detail.id;
                    var percent = event.detail.percent;
                    var seconds = event.detail.seconds;
                    if (that.playingCallback) {
                        that.playingCallback(id, percent, seconds);
                    }
                });
            }

            if (url.startsWith('http')) {
                var savePath = ucClient.ClientService.getDocumentDataDirSync(1) + "/notice/" + Date.now();
                that.downloadFile(url, savePath, function (path) {
                    startPlay(path, url);
                });
            } else {
                startPlay(url, url);
            }
        },
        stopPlayMedia: function () {
            var that = this;
            if (this.currentPlayingURL) {
                ucClient.System.stopSound(that.currentPlayingURL);
                delete this.currentPlayingURL;
                delete this.playingCallback;
            } else {
                ucClient.System.stopSound(localStorage.currentTaskAudio);
            }
        },
        openLocalMediaPlayer: function (url) {
            ucClient.System.playVideo(url);
        },
        openSaveFileDialog: function (title, saveName, desc, filter, callback) {
            var that = this;
            ucClient.Dialog.runSaveDialog(title, saveName, [{desc: desc, filter: filter}], function (args) {
                callback(args[0]);
            });
        },
        openFile: function (path) {
            ucClient.File.openFile(path);
        },
        openImagePreview: function (urlList, url) {
            top.localStorage.setItem('image-preview-data', JSON.stringify({
                imageList: urlList,
                imagePath: url,
                type: 'notice'
            }));
            this.requestNativeFn('uc.modules.image.ImageManager', 'openImagePreviewerWindow', [], function (result) {
            });
        },
        getGroupInfoSync: function (groupId) {
            return ucClient.GroupService.getGroupInfoSync(groupId);
        },
        getCurrentLanguage: function () {
            return appModule.lang;
        },
        showGroupNoticeMessage: function (data) {
            this.triggerGlobalEvent("showGroupNoticeMessage", {"data": data});
        },
        getImageFormat: function(filePath) {
            return ucClient.Image.getImageFormat(filePath);
        },
        getImageWidthHeight: function(filePath) {
            return ucClient.Image.getImageWidthHeight(filePath);
        }
    };
    nativeService.cloudFileEvents = {
        sendFromMount: null,
        noticeAlert: null,
        cancelSelectCloudFile: null
    };

    var cloudFileEventHandler = function (eventData) {
        if (nativeService.cloudFileEvents[eventData.type]) {
            nativeService.cloudFileEvents[eventData.type](eventData);
            //cancel 和 sendFromMount 同一时间触发一次 执行完后需要同时释放
            if (eventData.type == nativeService.cloudFileEvents.sendFromMount || eventData.type == nativeService.cloudFileEvents.cancelSelectCloudFile) {
                nativeService.cloudFileEvents.sendFromMount = null;
                nativeService.cloudFileEvents.cancelSelectCloudFile = null;
            } else {
                nativeService.cloudFileEvents[eventData.type] = null;
            }
        }
    };
    for (var evt in nativeService.cloudFileEvents) {
        nativeService.bindGlobalEvent(evt, cloudFileEventHandler);
    }

    nativeService.bindGlobalEvent(ucClient.BBSService.BBS_SERVICE_MAIN_EVENT, function (eventData) {
        if (eventData.detail && eventData.detail.requestID) {
            // console.log("receive request"+ eventData.detail.requestID);
            if (nativeService.bbsCallback && nativeService.bbsCallback[eventData.detail.requestID]) {
                nativeService.bbsCallback[eventData.detail.requestID]({
                    errorCode: eventData.detail.errorCode,
                    response: eventData.detail.response
                });
            }
        }
    });

    return nativeService;
});
